import gi
gi.require_version('Gtk', '4.0')
from gi.repository import Gtk, GLib

class CompletionView(Gtk.Box):
    """
    Ansicht, die den erfolgreichen Abschluss der Installation anzeigt.
    Bietet Optionen zum Neustarten des Systems oder zum Beenden des Installers.
    """
    def __init__(self, on_restart_callback, on_exit_callback):
        """
        Initialisiert die CompletionView.

        Args:
            on_restart_callback (callable): Funktion, die beim Klick auf 'Neustarten' aufgerufen wird.
            on_exit_callback (callable): Funktion, die beim Klick auf 'Beenden' aufgerufen wird.
        """
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=20)
        self.set_homogeneous(False)
        self.set_halign(Gtk.Align.CENTER)
        self.set_valign(Gtk.Align.CENTER)
        self.set_margin_top(50)
        self.set_margin_bottom(50)
        self.set_margin_start(50)
        self.set_margin_end(50)

        self._on_restart_callback = on_restart_callback
        self._on_exit_callback = on_exit_callback

        self._setup_ui()

    def _setup_ui(self):
        """
        Richtet die Benutzeroberfläche für die Abschlussansicht ein.
        """
        # Titel
        title_label = Gtk.Label.new()
        title_label.set_markup("<span font_desc='Sans Bold 24'>Installation erfolgreich abgeschlossen!</span>")
        title_label.set_halign(Gtk.Align.CENTER)
        self.append(title_label)

        # Nachricht
        message_label = Gtk.Label(label="Das Void Linux System wurde erfolgreich auf Ihrem Computer installiert.\n" +
                                  "Sie können das System jetzt neu starten, um es zu nutzen.")
        message_label.set_halign(Gtk.Align.CENTER)
        self.append(message_label)

        # Abstandshalter
        self.append(Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=30))

        # Button-Bereich
        button_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        button_box.set_halign(Gtk.Align.CENTER)

        # Neustart-Button
        restart_button = Gtk.Button(label="System neu starten")
        restart_button.add_css_class('suggested-action')
        restart_button.connect('clicked', self._on_restart_callback)
        button_box.append(restart_button)

        # Beenden-Button
        exit_button = Gtk.Button(label="Installer beenden")
        exit_button.connect('clicked', self._on_exit_callback)
        button_box.append(exit_button)

        self.append(button_box)
