
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import gi
gi.require_version("Gtk", "4.0")
from gi.repository import Gtk
from typing import List

# --- Paket-Konstanten ---
MIRRORS = [
    "Void Standard (repo-default)",
    "Frankfurt (Tier 1) - mirrors.servercentral.com/voidlinux",
    "Freiburg - mirror.eu.oneandone.net/voidlinux",
    "Amsterdam - mirror.csc.ru/voidlinux",
]
CINNAMON_SET = [
    "7zip", "acpi_call-dkms", "adwaita-icon-theme", "alsa-plugins-ffmpeg", "AppStream", "arc-theme", "avahi", "bash-completion", "base-devel", "btrfs-backup", "btrfs-progs", "cdrtools", "cinnamon-all", "cinnamon-control-center", "cinnamon-desktop", "cinnamon-screensaver", "cinnamon-session", "cinnamon-settings-daemon", "compsize", "colord", "cryptsetup", "curl", "dbus", "dbus-elogind", "dbus-elogind-x11", "dhclient", "dialog", "dejavu-fonts-ttf", "dkms", "dosfstools", "dtrx", "efibootmgr", "elogind", "engrampa", "exfat-utils", "fastfetch", "ffmpeg", "ffmpegthumbnailer", "file-roller", "freefont-ttf", "fuse-exfat", "fzf", "gedit", "git", "gnome-disk-utility", "gnome-icon-theme", "gnome-keyring", "gnome-terminal", "gptfdisk", "grub-btrfs", "grub-btrfs-runit", "gst-libav", "gvfs", "gvfs-afc", "gvfs-afp", "gvfs-cdda", "gvfs-gphoto2", "gvfs-mtp", "gvfs-smb", "ipp-usb", "liberation-fonts-ttf", "libavcodec", "libspa-bluetooth", "libvdpau-va-gl", "libxcrypt-compat", "lightdm", "lightdm-gtk-greeter", "lightdm-gtk-greeter-settings", "linux-driver-management", "linux-firmware", "linux-firmware-amd", "linux-firmware-intel", "linux-firmware-nvidia", "linux-headers", "lvm2", "lzip", "mdadm", "mesa-dri", "mesa-nouveau-dri", "mugshot", "nemo", "nemo-emblems", "nemo-extensions", "nemo-fileroller", "nemo-image-converter", "nemo-preview", "nemo-terminal", "noto-fonts-emoji", "noto-fonts-ttf", "noto-fonts-ttf-extra", "NetworkManager", "numlockx", "ntp", "nss-mdns", "ocs-url", "octoxbps", "openvpn", "os-prober", "papirus-icon-theme", "pavucontrol", "pipewire", "polkit", "python3-cups", "python3", "python3-dbus", "rpm", "rpmextract", "rsync", "samba", "setxkbmap", "simple-scan", "system-config-printer", "terminus-font", "tilix", "tlp", "tlpui", "topgrade", "udisks2", "unzip", "vdpauinfo", "void-repo-multilib", "void-repo-multilib-nonfree", "void-repo-nonfree", "vsv", "wget", "xauth", "xdg-desktop-portal", "xdg-desktop-portal-gtk", "xdg-desktop-portal-kde", "xdg-desktop-portal-wlr", "xdg-desktop-portal-xapp", "xdg-user-dirs", "xdg-user-dirs-gtk", "xdg-utils", "xf86-video-nouveau", "xorg-input-drivers", "xorg-minimal", "xorg-video-drivers", "xrandr", "xarchiver", "xz", "yad", "python3-gobject", "gtk+3", "gtk4", "python3-pyudev", "parted", "dosfstools", "desktop-file-utils", "gobject-introspection", "ca-certificates", "polkit", "at-spi2-core", "binutils", "tar"
]
BUNDLE_NVIDIA = ["nvidia", "nvidia-dkms", "nvidia-firmware"]
BUNDLE_PRINTER = ["cups", "cups-pdf", "cups-filters", "gutenprint"]
BUNDLE_PIPEWIRE = ["pipewire", "wireplumber", "alsa-pipewire"]
BUNDLE_NONFREE_CODECS = ["x264", "x265", "gst-plugins-bad1", "gst-plugins-ugly1"]
BUNDLE_FLATPAK = ["flatpak", "xdg-desktop-portal", "xdg-desktop-portal-gtk"]
BUNDLE_FIREFOX_DE = ["firefox", "firefox-i18n-de"]
BUNDLE_VIVALDI = ["vivaldi"]
BUNDLE_EVOLUTION = ["evolution"]
BUNDLE_THUNDERBIRD_DE = ["thunderbird", "thunderbird-i18n-de"]
BUNDLE_LIBREOFFICE_DE = ["libreoffice", "libreoffice-i18n-de"]
PKG_GNOME_CALENDAR = "gnome-calendar"
PKG_PAPERS = "papers"
PKG_EVINCE = "evince"
PKG_VLC = "vlc"
PKG_RHYTHMBOX = "rhythmbox"
PKG_KDENLIVE = "kdenlive"
PKG_OBS = "obs"

class SoftwareConfigView(Gtk.Box):
    def __init__(self):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        for s in (self.set_margin_top, self.set_margin_bottom, self.set_margin_start, self.set_margin_end): s(16)

        title = Gtk.Label.new("Software & Konfiguration"); title.add_css_class("title-2"); title.set_halign(Gtk.Align.START); self.append(title)
        sc = Gtk.ScrolledWindow(); sc.set_vexpand(True); self.append(sc)
        root = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12); sc.set_child(root)

        f_repo = Gtk.Frame(label="Repository Server (EU)"); f_repo.add_css_class("card"); root.append(f_repo)
        box_repo = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=8, margin_top=10, margin_bottom=10, margin_start=10, margin_end=10); f_repo.set_child(box_repo)
        mirror_label = Gtk.Label.new("Mirror:")
        box_repo.append(mirror_label)
        self.cmb_mirror = Gtk.ComboBoxText()
        for m in MIRRORS: self.cmb_mirror.append_text(m)
        try: idx = MIRRORS.index("Frankfurt (Tier 1) - mirrors.servercentral.com/voidlinux")
        except ValueError: idx = 0
        self.cmb_mirror.set_active(idx); box_repo.append(self.cmb_mirror)

        f_de = Gtk.Frame(label="Desktop"); f_de.add_css_class("card"); root.append(f_de)
        box_de = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=6, margin_top=10, margin_bottom=10, margin_start=10, margin_end=10); f_de.set_child(box_de)
        self.cb_cinnamon = Gtk.CheckButton.new_with_label("Cinnamon Desktop (empfohlene Auswahl)"); self.cb_cinnamon.set_active(True); box_de.append(self.cb_cinnamon)

        f_extra = Gtk.Frame(label="Zusätzliche Pakete (Schnellauswahl)"); f_extra.add_css_class("card"); root.append(f_extra)
        grid_main = Gtk.Grid(column_spacing=20, row_spacing=10, margin_top=10, margin_bottom=10, margin_start=10, margin_end=10); f_extra.set_child(grid_main)

        # Spalte 1: System
        frame_system = Gtk.Frame(label="System"); frame_system.add_css_class("card"); grid_main.attach(frame_system, 0, 0, 1, 1)
        box_system = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8, margin_top=5, margin_bottom=5, margin_start=5, margin_end=5); frame_system.set_child(box_system)
        self.cb_nvidia   = Gtk.CheckButton.new_with_label("NVIDIA Treiber"); box_system.append(self.cb_nvidia)
        self.cb_printer  = Gtk.CheckButton.new_with_label("Druckerunterstützung"); box_system.append(self.cb_printer)
        self.cb_pipewire = Gtk.CheckButton.new_with_label("PipeWire Audio-Stack"); self.cb_pipewire.set_active(True); box_system.append(self.cb_pipewire)
        self.cb_codecs   = Gtk.CheckButton.new_with_label("Nonfree Codecs"); self.cb_codecs.set_active(True); box_system.append(self.cb_codecs)
        self.cb_flatpak  = Gtk.CheckButton.new_with_label("Flatpak-Unterstützung"); self.cb_flatpak.set_active(True); box_system.append(self.cb_flatpak)

        # Spalte 2: Internet
        frame_internet = Gtk.Frame(label="Internet"); frame_internet.add_css_class("card"); grid_main.attach(frame_internet, 1, 0, 1, 1)
        box_internet = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8, margin_top=5, margin_bottom=5, margin_start=5, margin_end=5); frame_internet.set_child(box_internet)
        self.cb_firefox  = Gtk.CheckButton.new_with_label("Firefox (de)"); self.cb_firefox.set_active(True); box_internet.append(self.cb_firefox)
        self.cb_vivaldi = Gtk.CheckButton.new_with_label("Vivaldi"); box_internet.append(self.cb_vivaldi)
        self.cb_evolution = Gtk.CheckButton.new_with_label("Evolution"); box_internet.append(self.cb_evolution)
        self.cb_thunderbird = Gtk.CheckButton.new_with_label("Thunderbird (de)"); box_internet.append(self.cb_thunderbird)

        # Spalte 3: Office
        frame_office = Gtk.Frame(label="Office"); frame_office.add_css_class("card"); grid_main.attach(frame_office, 2, 0, 1, 1)
        box_office = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8, margin_top=5, margin_bottom=5, margin_start=5, margin_end=5); frame_office.set_child(box_office)
        self.cb_libre    = Gtk.CheckButton.new_with_label("LibreOffice (de)"); box_office.append(self.cb_libre)
        self.cb_calendar = Gtk.CheckButton.new_with_label("GNOME Calendar"); box_office.append(self.cb_calendar)
        self.cb_papers   = Gtk.CheckButton.new_with_label("Papers"); box_office.append(self.cb_papers)
        self.cb_evince   = Gtk.CheckButton.new_with_label("Evince (PDF)"); box_office.append(self.cb_evince)

        # Spalte 4: Multimedia
        frame_media = Gtk.Frame(label="Multimedia"); frame_media.add_css_class("card"); grid_main.attach(frame_media, 3, 0, 1, 1)
        box_media = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8, margin_top=5, margin_bottom=5, margin_start=5, margin_end=5); frame_media.set_child(box_media)
        self.cb_vlc      = Gtk.CheckButton.new_with_label("VLC"); box_media.append(self.cb_vlc)
        self.cb_rhythmbox= Gtk.CheckButton.new_with_label("Rhythmbox"); box_media.append(self.cb_rhythmbox)
        self.cb_kdenlive = Gtk.CheckButton.new_with_label("Kdenlive"); box_media.append(self.cb_kdenlive)
        self.cb_obs      = Gtk.CheckButton.new_with_label("OBS Studio"); box_media.append(self.cb_obs)

        f_inc = Gtk.Frame(label="Include-ROOT Overlay (wird 1:1 ins Ziel kopiert)"); f_inc.add_css_class("card"); root.append(f_inc)
        box_inc = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8, margin_top=10, margin_bottom=10, margin_start=10, margin_end=10); f_inc.set_child(box_inc)
        row_inc = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=8); box_inc.append(row_inc)
        path_label = Gtk.Label.new("Pfad:")
        row_inc.append(path_label); self.entry_include = Gtk.Entry(); self.entry_include.set_placeholder_text("/etc/void-installer/include-root (oder eigener Pfad)"); row_inc.append(self.entry_include)
        info = Gtk.Label.new("Tipp: Lege im Include-Ordner die gleiche Verzeichnisstruktur wie im Ziel an, alles wird 1:1 kopiert."); info.set_wrap(True); box_inc.append(info)

    def get_selected_mirror(self) -> str:
        txt = self.cmb_mirror.get_active_text() or ""; return txt if txt else MIRRORS[0]

    def get_selected_packages(self) -> List[str]:
        pkgs: List[str] = []
        if self.cb_cinnamon.get_active(): pkgs.extend(CINNAMON_SET)
        if self.cb_nvidia.get_active(): pkgs.extend(BUNDLE_NVIDIA)
        if self.cb_printer.get_active(): pkgs.extend(BUNDLE_PRINTER)
        if self.cb_pipewire.get_active(): pkgs.extend(BUNDLE_PIPEWIRE)
        if self.cb_codecs.get_active(): pkgs.extend(BUNDLE_NONFREE_CODECS)
        if self.cb_flatpak.get_active(): pkgs.extend(BUNDLE_FLATPAK)
        if self.cb_firefox.get_active(): pkgs.extend(BUNDLE_FIREFOX_DE)
        if self.cb_vivaldi.get_active(): pkgs.extend(BUNDLE_VIVALDI)
        if self.cb_evolution.get_active(): pkgs.extend(BUNDLE_EVOLUTION)
        if self.cb_thunderbird.get_active(): pkgs.extend(BUNDLE_THUNDERBIRD_DE)
        if self.cb_libre.get_active(): pkgs.extend(BUNDLE_LIBREOFFICE_DE)
        if self.cb_calendar.get_active(): pkgs.append(PKG_GNOME_CALENDAR)
        if self.cb_papers.get_active(): pkgs.append(PKG_PAPERS)
        if self.cb_evince.get_active(): pkgs.append(PKG_EVINCE)
        if self.cb_vlc.get_active(): pkgs.append(PKG_VLC)
        if self.cb_rhythmbox.get_active(): pkgs.append(PKG_RHYTHMBOX)
        if self.cb_kdenlive.get_active(): pkgs.append(PKG_KDENLIVE)
        if self.cb_obs.get_active(): pkgs.append(PKG_OBS)

        seen = set(); out = []
        for p in pkgs:
            if p not in seen:
                out.append(p); seen.add(p)
        return out

    def get_include_root(self) -> str:
        return (self.entry_include.get_text() or "").strip()
