#!/bin/bash

# ==============================================================================
# Skript zum Ersetzen von PipeWire durch PulseAudio auf Void Linux (XFCE Edition)
# ==============================================================================

# Beendet das Skript sofort, wenn ein Befehl fehlschlägt
set -euo pipefail

# --- Paketlisten ---
# Pakete, die entfernt werden sollen
PIPEWIRE_PACKAGES="pipewire wireplumber pipewire-pulse libspa-bluetooth alsa-pipewire"

# Pakete, die installiert werden sollen (inklusive xfce4-pulseaudio-plugin)
PULSEAUDIO_PACKAGES="pulseaudio alsa-plugins-pulseaudio pavucontrol xfce4-pulseaudio-plugin"


# --- Hauptfunktion ---
main() {
    # 1. Prüfen, ob das Skript als root ausgeführt wird
    if [ "$EUID" -ne 0 ]; then
        echo "Fehler: Dieses Skript muss mit Root-Rechten ausgeführt werden."
        echo "Bitte führen Sie es mit 'sudo ./ton.sh' aus."
        exit 1
    fi

    # 2. Warnung und Bestätigung durch den Benutzer
    echo "================================ WARNUNG ================================"
    echo "Dieses Skript wird die folgenden Änderungen an Ihrem System vornehmen:"
    echo
    echo "  1. Alle PipeWire-Komponenten werden gestoppt und deinstalliert:"
    echo "     - $PIPEWIRE_PACKAGES"
    echo
    echo "  2. PulseAudio und zugehörige Komponenten werden installiert:"
    echo "     - $PULSEAUDIO_PACKAGES"
    echo
    echo "Dies ist eine tiefgreifende Änderung am Audio-Subsystem."
    echo "======================================================================="
    echo

    read -p "Möchten Sie fortfahren? (j/N): " choice
    case "$choice" in
      j|J )
        echo "Bestätigt. Der Vorgang wird gestartet..."
        ;;
      * )
        echo "Vorgang abgebrochen."
        exit 0
        ;;
    esac

    # 3. PipeWire-Prozesse stoppen
    echo
    echo "-> Schritt 1/3: Beende laufende PipeWire-Prozesse..."
    # pkill beendet Prozesse basierend auf ihrem Namen
    pkill -f pipewire &>/dev/null || true
    pkill -f wireplumber &>/dev/null || true
    echo "PipeWire-Prozesse wurden beendet (falls sie liefen)."

    # 4. PipeWire-Pakete entfernen
    echo
    echo "-> Schritt 2/3: Entferne PipeWire-Pakete..."
    # -R entfernt auch verwaiste Abhängigkeiten
    if ! xbps-remove -R $PIPEWIRE_PACKAGES; then
        echo "Fehler beim Entfernen der PipeWire-Pakete. Breche ab."
        exit 1
    fi
    echo "PipeWire wurde erfolgreich entfernt."

    # 5. PulseAudio-Pakete installieren
    echo
    echo "-> Schritt 3/3: Installiere PulseAudio-Pakete..."
    # -S synchronisiert die Paketdatenbanken vor der Installation
    if ! xbps-install -S $PULSEAUDIO_PACKAGES; then
        echo "Fehler bei der Installation der PulseAudio-Pakete."
        exit 1
    fi
    echo "PulseAudio wurde erfolgreich installiert."

    # 6. Abschließende Nachricht
    echo
    echo "======================= VORGANG ABGESCHLOSSEN ======================="
    echo "Der Wechsel von PipeWire zu PulseAudio ist abgeschlossen."
    echo
    echo "!!! WICHTIG: Bitte starten Sie Ihren Computer jetzt neu, !!!"
    echo "!!! damit die Änderungen vollständig wirksam werden.     !!!"
    echo
    echo "Nach dem Neustart musst du eventuell das 'PulseAudio-Plugin'"
    echo "manuell zur XFCE-Leiste hinzufügen (Rechtsklick auf Leiste -> Leiste -> Neue Elemente hinzufügen)."
    echo "======================================================================="
}

# Skript ausführen
main